<?php
require "config.php";

	if (!isset($_COOKIE['id'])) {
		header("Location: reglog.php");
		exit;
	}

	$rendezveny_azonosito = isset($_GET['id']) ? $_GET['id'] : 0;

	// Kosár sütiből beolvasás
	$kosar = array();
	if (isset($_COOKIE['kosar']) && $_COOKIE['kosar'] != '') {
		$elemek = explode(',', $_COOKIE['kosar']);
		foreach ($elemek as $egy_elem) {
			if ($egy_elem == '') continue;

		$reszek = explode(':', $egy_elem);
		$jegy_azonosito = isset($reszek[0]) ? $reszek[0] : '';
		$mennyiseg = isset($reszek[1]) ? $reszek[1] : '';

		if ($jegy_azonosito != '' && $mennyiseg != '' && $mennyiseg > 0) {
			if (!isset($kosar[$jegy_azonosito])) {
				$kosar[$jegy_azonosito] = 0;
			}
			$kosar[$jegy_azonosito] = $kosar[$jegy_azonosito] + $mennyiseg;
		}
	}
}

	// Jegy kosárba helyezése
	$uzenet = "";
	if (isset($_POST['jegy_azonosito']) && isset($_POST['mennyiseg'])) {
		$jegy_azonosito = $_POST['jegy_azonosito'];
		$mennyiseg = $_POST['mennyiseg'];

	if ($mennyiseg < 1) {
		$mennyiseg = 1;
	}

	if ($jegy_azonosito != '') {
		if (!isset($kosar[$jegy_azonosito])) {
			$kosar[$jegy_azonosito] = 0;
		}

		$kosar[$jegy_azonosito] = $kosar[$jegy_azonosito] + $mennyiseg;

		$parok = array();
		foreach ($kosar as $azonosito => $mennyiseg) {
			if ($mennyiseg > 0) {
				$parok[] = $azonosito . ':' . $mennyiseg;
			}
		}
		$ertek = implode(',', $parok);
		setcookie('kosar', $ertek, time() + 3600, '/');

		$uzenet = "A jegyek sikeresen a kosárba kerültek.";
	}
}

// Rendezvény lekérése
	$rendezveny = null;
	
	if ($rendezveny_azonosito != 0 && $rendezveny_azonosito != '') {
		$eredmeny = $conn->query("SELECT * FROM events WHERE id=$rendezveny_azonosito");
		
	if ($eredmeny && $eredmeny->num_rows == 1) {
		$rendezveny = $eredmeny->fetch_assoc();
	}
}
?>
	<!DOCTYPE html>
	<html lang="hu">
	<head>
	<meta charset="UTF-8">
	<title><?php echo $rendezveny ? $rendezveny['title'].' – Rendezvény' : 'Rendezvény'; ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
	<link rel="stylesheet" href="css/styles.css">
	</head>
	<body>

<?php include "nav.php"; ?>

<?php
	if (!$rendezveny) {
		echo '<div class="content"><div class="search-text">A kért rendezvény nem található.</div></div>';
	} else {
		$cim = $rendezveny['title'];
		$leiras = $rendezveny['description'];
		$ev = $rendezveny['year'];
		$honap = $rendezveny['month'];
		$nap = $rendezveny['day'];
		$ora = $rendezveny['hour'];
		$perc = $rendezveny['minute'];
		$kep = $rendezveny['image_path'] != '' ? $rendezveny['image_path'] : "uploads/events/placeholder.jpg";


		$ido = new DateTime();
		$ido->setDate($ev, $honap, $nap);
		$ido->setTime($ora, $perc);
		$datum_szoveg = $ido->format("Y.m.d H:i");

		$jegyek = array();
		$lekerdezes = $conn->query("SELECT * FROM tickets WHERE event_id=$rendezveny_azonosito ORDER BY price");
		if ($lekerdezes && $lekerdezes->num_rows > 0) {
		while ($sor = $lekerdezes->fetch_assoc()) {
			$jegyek[] = $sor;
		}
	}

	echo '
	<div class="content">
		<section class="product-page">';

		if ($uzenet != "") {
			echo '<div class="alert success">'.$uzenet.'</div>';
		}

		echo '
		<div class="product-header">
			<h1 class="product-title">'.$cim.'</h1>
			<div class="product-meta">Dátum: '.$datum_szoveg.'</div>
		</div>

		<div class="product-top">
			<div class="product-gallery">
			<img class="product-image" src="'.$kep.'" alt="'.$cim.'">
		</div>

		<div class="product-meta">
			<h3>Elérhető jegyek</h3>';
            
			if (count($jegyek) == 0) {
				echo '<p>Nincs elérhető jegy ehhez a rendezvényhez.</p>';
			} else {
				foreach ($jegyek as $egy_jegy) {
					$jegy_azonosito = $egy_jegy['id'];
					$jegy_nev = $egy_jegy['name'];
					$jegy_ar = number_format($egy_jegy['price'], 0, ',', ' ');
					$jegy_keszlet = $egy_jegy['quantity'];

					echo '
					<div class="product-tags">
						<span class="badge">'.$jegy_nev.'</span> 
						<span class="price">'.$jegy_ar.' Ft</span><br>';

					if ($jegy_keszlet > 0) {
						echo '<span class="keszlet ok">Készlet: '.$jegy_keszlet.' db</span>
						<form method="post" action="?id='.$rendezveny_azonosito.'" class="product-actions">
							<input type="hidden" name="jegy_azonosito" value="'.$jegy_azonosito.'">
							<input type="number" name="mennyiseg" min="1" max="'.$jegy_keszlet.'" value="1" style="width:90px;margin-right:8px;">
							<button class="btn btn-primary" type="submit">Kosárba</button>
						</form>';
					} else {
						echo '<span class="keszlet no">Elfogyott</span>';
                    }

					echo '</div><hr>';
				}
			}

		echo '  </div>
		</div>

		<article class="product-desc">
			<h2>Leírás</h2>
		<p>'.nl2br($leiras).'</p>
		</article>

		</section>
	</div>';
}
?>
</body>
</html>